/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.fabric.transfer.InventoryStorage;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.shared.block.entity.TableBlockEntity;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.AbstractCastingBlock;
import slimeknights.tconstruct.smeltery.block.entity.inventory.CastingContainerWrapper;
import slimeknights.tconstruct.smeltery.block.entity.inventory.MoldingContainerWrapper;
import slimeknights.tconstruct.smeltery.block.entity.tank.CastingFluidHandler;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public abstract class CastingBlockEntity
extends TableBlockEntity
implements class_1278,
FluidUpdatePacket.IFluidPacketReceiver,
SidedStorageBlockEntity {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private static final String TAG_TANK = "tank";
    private static final String TAG_TIMER = "timer";
    private static final String TAG_RECIPE = "recipe";
    private static final String TAG_REDSTONE = "redstone";
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "casting");
    public static final class_5558<CastingBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.serverTick(level, pos);
    public static final class_5558<CastingBlockEntity> CLIENT_TICKER = (level, pos, state, self) -> self.clientTick(level, pos);
    private final CastingFluidHandler tank = new CastingFluidHandler(this);
    private final class_3956<ICastingRecipe> castingType;
    private final CastingContainerWrapper castingInventory;
    private int timer;
    private int coolingTime = -1;
    private ICastingRecipe currentRecipe;
    private class_2960 recipeName;
    private ICastingRecipe lastCastingRecipe;
    private class_1799 lastOutput = null;
    private final boolean requireCast;
    private final class_6862<class_1792> emptyCastTag;
    private final class_3956<MoldingRecipe> moldingType;
    private final MoldingContainerWrapper moldingInventory;
    private MoldingRecipe lastMoldingRecipe;
    private boolean lastRedstone = false;
    private long lastAnalogSignal;

    protected CastingBlockEntity(class_2591<?> beType, class_2338 pos, class_2680 state, class_3956<ICastingRecipe> castingType, class_3956<MoldingRecipe> moldingType, class_6862<class_1792> emptyCastTag) {
        super(beType, pos, state, NAME, 2, 1);
        AbstractCastingBlock casting;
        class_2248 class_22482 = state.method_26204();
        this.requireCast = class_22482 instanceof AbstractCastingBlock && (casting = (AbstractCastingBlock)class_22482).isRequireCast();
        this.emptyCastTag = emptyCastTag;
        this.itemHandler = InventoryStorage.of(this, class_2350.field_11033);
        this.castingType = castingType;
        this.moldingType = moldingType;
        this.castingInventory = new CastingContainerWrapper(this);
        this.moldingInventory = new MoldingContainerWrapper((SlottedStorage<ItemVariant>)this.itemHandler, 0);
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        return this.tank;
    }

    public void interact(class_1657 player, class_1268 hand) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.tank.isEmpty()) {
            return;
        }
        class_1799 held = player.method_5998(hand);
        class_1799 input = this.method_5438(0);
        class_1799 output = this.method_5438(1);
        if (!input.method_7960() && output.method_7960()) {
            this.moldingInventory.setPattern(held);
            MoldingRecipe recipe = this.findMoldingRecipe();
            if (recipe != null) {
                class_1799 result = recipe.method_8116(this.moldingInventory, this.field_11863.method_30349());
                result.method_7982(this.field_11863, player, 1);
                if (held.method_7960()) {
                    this.method_5447(0, class_1799.field_8037);
                    player.method_6122(hand, result);
                } else {
                    this.method_5447(0, result);
                    if (!recipe.isPatternConsumed()) {
                        this.method_5447(1, ItemHandlerHelper.copyStackWithSize((class_1799)held, (int)1));
                        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
                    }
                    held.method_7934(1);
                    player.method_6122(hand, held.method_7960() ? class_1799.field_8037 : held);
                }
                this.moldingInventory.setPattern(class_1799.field_8037);
                return;
            }
            this.moldingInventory.setPattern(class_1799.field_8037);
            recipe = this.findMoldingRecipe();
            if (recipe != null) {
                this.method_5447(0, class_1799.field_8037);
                ItemHandlerHelper.giveItemToPlayer((class_1657)player, (class_1799)recipe.method_8116(this.moldingInventory, this.field_11863.method_30349()), (int)player.method_31548().field_7545);
                return;
            }
            this.moldingInventory.setPattern(class_1799.field_8037);
        }
        if (input.method_7960() && output.method_7960()) {
            if (!held.method_7960()) {
                class_1799 stack = held.method_7971(this.stackSizeLimit);
                player.method_6122(hand, held.method_7960() ? class_1799.field_8037 : held);
                this.method_5447(0, stack);
            }
        } else {
            int slot = output.method_7960() ? 0 : 1;
            class_1799 stack = this.method_5438(slot);
            ItemHandlerHelper.giveItemToPlayer((class_1657)player, (class_1799)stack, (int)player.method_31548().field_7545);
            this.method_5447(slot, class_1799.field_8037);
            if (slot == 1) {
                this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 original = this.method_5438(slot);
        super.method_5447(slot, stack);
        if (original.method_7960() != stack.method_7960()) {
            this.updateAnalogSignal();
        }
    }

    public void handleRedstone(boolean hasSignal) {
        if (this.lastRedstone != hasSignal) {
            if (hasSignal && this.field_11863 != null) {
                this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 2);
            }
            this.lastRedstone = hasSignal;
        }
    }

    public void swap() {
        if (this.currentRecipe == null) {
            class_1799 output = this.method_5438(1);
            this.method_5447(1, this.method_5438(0));
            this.method_5447(0, output);
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, this.method_11016(), Sounds.CASTING_CLICKS.getSound(), class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public int[] method_5494(class_2350 side) {
        return new int[]{0, 1};
    }

    public boolean method_5492(int index, class_1799 itemStackIn, @javax.annotation.Nullable class_2350 direction) {
        return this.tank.isEmpty() && index == 0 && !this.isStackInSlot(1);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return this.tank.isEmpty() && index == 1;
    }

    private void serverTick(class_1937 level, class_2338 pos) {
        if (this.currentRecipe == null) {
            return;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (this.coolingTime >= 0) {
            ++this.timer;
            if (this.timer >= this.coolingTime) {
                if (!this.currentRecipe.method_8115(this.castingInventory, level)) {
                    this.currentRecipe = this.findCastingRecipe();
                    this.recipeName = null;
                    if (this.currentRecipe == null || this.currentRecipe.getFluidAmount(this.castingInventory) > currentFluid.getAmount()) {
                        this.timer = 0;
                        this.updateAnalogSignal();
                        return;
                    }
                }
                class_1799 output = this.currentRecipe.method_8116(this.castingInventory, level.method_30349());
                if (this.currentRecipe.switchSlots() != this.lastRedstone) {
                    if (!this.currentRecipe.isConsumed()) {
                        this.method_5447(1, this.method_5438(0));
                    }
                    this.method_5447(0, output);
                    level.method_8396(null, this.method_11016(), Sounds.CASTING_CLICKS.getSound(), class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    if (this.currentRecipe.isConsumed()) {
                        this.method_5447(0, class_1799.field_8037);
                    }
                    this.method_5447(1, output);
                }
                level.method_8396(null, pos, Sounds.CASTING_COOLS.getSound(), class_3419.field_15245, 0.5f, 4.0f);
                this.reset();
            } else {
                this.updateAnalogSignal();
            }
        }
    }

    private void clientTick(class_1937 level, class_2338 pos) {
        if (this.currentRecipe == null) {
            return;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (currentFluid.getAmount() >= this.tank.getCapacity() && !currentFluid.isEmpty()) {
            ++this.timer;
            if (level.field_9229.method_43057() > 0.9f) {
                level.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + level.field_9229.method_43058(), (double)pos.method_10264() + 1.1, (double)pos.method_10260() + level.field_9229.method_43058(), 0.0, 0.0, 0.0);
            }
        }
    }

    @javax.annotation.Nullable
    private ICastingRecipe findCastingRecipe() {
        if (this.field_11863 == null) {
            return null;
        }
        if (this.lastCastingRecipe != null && this.lastCastingRecipe.method_8115(this.castingInventory, this.field_11863)) {
            return this.lastCastingRecipe;
        }
        ICastingRecipe castingRecipe = this.field_11863.method_8433().method_8132(this.castingType, (class_1263)this.castingInventory, this.field_11863).orElse(null);
        if (castingRecipe != null) {
            this.lastCastingRecipe = castingRecipe;
        }
        return castingRecipe;
    }

    @javax.annotation.Nullable
    private MoldingRecipe findMoldingRecipe() {
        if (this.field_11863 == null) {
            return null;
        }
        if (this.lastMoldingRecipe != null && this.lastMoldingRecipe.matches(this.moldingInventory, this.field_11863)) {
            return this.lastMoldingRecipe;
        }
        Optional newRecipe = this.field_11863.method_8433().method_8132(this.moldingType, (class_1263)this.moldingInventory, this.field_11863);
        if (newRecipe.isPresent()) {
            this.lastMoldingRecipe = (MoldingRecipe)newRecipe.get();
            return this.lastMoldingRecipe;
        }
        return null;
    }

    public long initNewCasting(FluidStack fluid, TransactionContext tx) {
        boolean hasOutput;
        if (this.currentRecipe != null || this.recipeName != null) {
            return 0L;
        }
        boolean hasInput = !this.method_5438(0).method_7960();
        boolean bl = hasOutput = !this.method_5438(1).method_7960();
        if (hasInput && hasOutput) {
            return 0L;
        }
        this.castingInventory.setFluid(fluid);
        if (!hasOutput) {
            if (!hasInput && this.requireCast) {
                return 0L;
            }
            this.castingInventory.useInput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                tx.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        this.currentRecipe = castingRecipe;
                        this.recipeName = null;
                        this.lastOutput = null;
                    }
                });
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        } else {
            this.castingInventory.useOutput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                tx.addOuterCloseCallback(result -> {
                    if (result.wasCommitted()) {
                        this.currentRecipe = castingRecipe;
                        this.recipeName = null;
                        this.lastOutput = null;
                        this.method_5447(0, this.method_5438(1));
                        this.method_5447(1, class_1799.field_8037);
                        this.castingInventory.useInput();
                    }
                });
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        }
        return 0L;
    }

    public void reset() {
        this.timer = 0;
        this.currentRecipe = null;
        this.recipeName = null;
        this.lastOutput = null;
        this.castingInventory.setFluid(FluidStack.EMPTY);
        this.tank.reset();
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack.getAmount() >= this.tank.getCapacity() && this.currentRecipe != null) {
            this.castingInventory.setFluid(fluidStack);
            this.coolingTime = Math.max(0, this.currentRecipe.getCoolingTime(this.castingInventory));
        } else {
            this.coolingTime = -1;
        }
        this.setChangedFast();
        this.updateAnalogSignal();
        class_1937 world = this.method_10997();
        if (world != null && !world.field_9236) {
            class_2338 pos = this.method_11016();
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new FluidUpdatePacket(pos, fluidStack), (class_1936)world, pos);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.reset();
        } else {
            try (Transaction tx = TransferUtil.getTransaction();){
                long capacity = this.initNewCasting(fluid, (TransactionContext)tx);
                if (capacity > 0L) {
                    this.tank.setCapacity(capacity);
                }
                tx.commit();
            }
        }
        this.tank.setFluid(fluid);
        this.onContentsChanged();
    }

    @javax.annotation.Nullable
    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
        return null;
    }

    public class_1799 getRecipeOutput() {
        if (this.lastOutput == null) {
            if (this.currentRecipe == null) {
                return class_1799.field_8037;
            }
            this.castingInventory.setFluid(this.tank.getFluid());
            this.lastOutput = this.currentRecipe.method_8116(this.castingInventory, this.field_11863.method_30349());
        }
        return this.lastOutput;
    }

    private void updateAnalogSignal() {
        long newStrength;
        if (!(this.field_11863 != null && this.field_11863.field_9236 || (newStrength = this.getAnalogSignal()) == this.lastAnalogSignal)) {
            this.lastAnalogSignal = newStrength;
            if (this.field_11863 != null) {
                this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
            }
        }
    }

    public long getAnalogSignal() {
        if (this.isStackInSlot(1)) {
            return 15L;
        }
        if (this.coolingTime > 0) {
            return 11L + (long)this.timer * 4L / (long)this.coolingTime;
        }
        long capacity = this.tank.getCapacity();
        if (capacity > 0L) {
            return 2L + this.tank.getFluid().getAmount() * 9L / capacity;
        }
        if (this.isStackInSlot(0)) {
            return 1L;
        }
        return 0L;
    }

    private void loadRecipe(class_1937 level, class_2960 name) {
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            RecipeHelper.getRecipe(level.method_8433(), name, ICastingRecipe.class).ifPresent(recipe -> {
                this.currentRecipe = recipe;
                this.castingInventory.setFluid(fluid);
                this.tank.setCapacity(recipe.getFluidAmount(this.castingInventory));
                if (fluid.getAmount() >= this.tank.getCapacity()) {
                    this.coolingTime = recipe.getCoolingTime(this.castingInventory);
                }
            });
        }
    }

    public void method_31662(class_1937 pLevel) {
        super.method_31662(pLevel);
        if (this.recipeName != null) {
            this.loadRecipe(pLevel, this.recipeName);
            this.recipeName = null;
        }
    }

    @Override
    public void method_11007(class_2487 tags) {
        super.method_11007(tags);
        tags.method_10556(TAG_REDSTONE, this.lastRedstone);
    }

    @Override
    public void saveSynced(class_2487 tags) {
        super.saveSynced(tags);
        tags.method_10566(TAG_TANK, (class_2520)this.tank.writeToTag(new class_2487()));
        if (this.currentRecipe != null || this.recipeName != null) {
            tags.method_10569(TAG_TIMER, this.timer);
        }
        if (this.currentRecipe != null) {
            tags.method_10582(TAG_RECIPE, this.currentRecipe.method_8114().toString());
        } else if (this.recipeName != null) {
            tags.method_10582(TAG_RECIPE, this.recipeName.toString());
        }
    }

    @Override
    public void method_11014(class_2487 tags) {
        super.method_11014(tags);
        this.tank.readFromTag(tags.method_10562(TAG_TANK));
        this.timer = tags.method_10550(TAG_TIMER);
        if (tags.method_10573(TAG_RECIPE, 8)) {
            class_2960 name = new class_2960(tags.method_10558(TAG_RECIPE));
            if (this.field_11863 != null) {
                this.loadRecipe(this.field_11863, name);
            } else {
                this.recipeName = name;
            }
        }
        this.lastRedstone = tags.method_10577(TAG_REDSTONE);
    }

    @javax.annotation.Nullable
    public static <CAST extends CastingBlockEntity, RET extends class_2586> class_5558<RET> getTicker(class_1937 level, class_2591<RET> check, class_2591<CAST> casting) {
        return BlockEntityHelper.castTicker(check, casting, level.field_9236 ? CLIENT_TICKER : SERVER_TICKER);
    }

    public CastingFluidHandler getTank() {
        return this.tank;
    }

    public int getTimer() {
        return this.timer;
    }

    public int getCoolingTime() {
        return this.coolingTime;
    }

    public class_6862<class_1792> getEmptyCastTag() {
        return this.emptyCastTag;
    }

    public static class Table
    extends CastingBlockEntity {
        public Table(class_2338 pos, class_2680 state) {
            super((class_2591)TinkerSmeltery.table.get(), pos, state, (class_3956<ICastingRecipe>)((class_3956)TinkerRecipeTypes.CASTING_TABLE.get()), (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()), TinkerTags.Items.TABLE_EMPTY_CASTS);
        }
    }

    public static class Basin
    extends CastingBlockEntity {
        public Basin(class_2338 pos, class_2680 state) {
            super((class_2591)TinkerSmeltery.basin.get(), pos, state, (class_3956<ICastingRecipe>)((class_3956)TinkerRecipeTypes.CASTING_BASIN.get()), (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()), TinkerTags.Items.BASIN_EMPTY_CASTS);
        }
    }
}

